/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTBoatTypes;
import com.stevekung.fishofthieves.registry.FOTDisplayItems;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.Util;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.slf4j.Logger;

public class FishOfThieves {
    public static final String MOD_ID = "fishofthieves";
    public static final String MOD_RESOURCES = "fishofthieves:";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final FishOfThievesConfig CONFIG = (FishOfThievesConfig)AutoConfig.register(FishOfThievesConfig.class, GsonConfigSerializer::new).getConfig();
    public static final ResourceKey<CreativeModeTab> FOT_MAIN = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)FishOfThieves.id("fot_main"));
    public static final ResourceKey<CreativeModeTab> FOT_FISH = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)FishOfThieves.id("fot"));

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void initCommon() {
        DispenseItemBehavior bucket = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.WATER_BUCKET);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.SPLASHTAIL_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.PONDIE_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.ISLEHOPPER_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.ANCIENTSCALE_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.PLENTIFIN_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.WILDSPLASH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.DEVILFISH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.BATTLEGILL_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.WRECKER_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.STORMFISH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.registerBehavior((ItemLike)FOTItems.COCONUT_BOAT, (DispenseItemBehavior)new BoatDispenseItemBehavior(FOTBoatTypes.COCONUT));
        DispenserBlock.registerBehavior((ItemLike)FOTItems.COCONUT_CHEST_BOAT, (DispenseItemBehavior)new BoatDispenseItemBehavior(FOTBoatTypes.COCONUT, true));
        FOTPlatform.addComposting((ItemLike)FOTItems.EARTHWORMS, 0.4f);
        FOTPlatform.addComposting((ItemLike)FOTItems.GRUBS, 0.4f);
        FOTPlatform.addComposting((ItemLike)FOTItems.LEECHES, 0.4f);
        FOTPlatform.addComposting((ItemLike)FOTItems.COCONUT, 0.5f);
        FOTPlatform.addComposting((ItemLike)FOTItems.BANANA, 0.3f);
        FOTPlatform.addComposting((ItemLike)FOTItems.PINEAPPLE, 0.7f);
        FOTPlatform.addComposting((ItemLike)FOTItems.CROWNLESS_PINEAPPLE, 0.65f);
        FOTPlatform.addComposting((ItemLike)FOTItems.HALF_PINEAPPLE, 0.35f);
        FOTPlatform.addComposting((ItemLike)FOTItems.PINEAPPLE_SEEDS, 0.1f);
        FOTPlatform.addComposting((ItemLike)FOTItems.PINEAPPLE_CROWN, 0.15f);
        FOTPlatform.addComposting((ItemLike)FOTItems.MANGO, 0.3f);
        FOTPlatform.addComposting((ItemLike)FOTItems.RAW_MANGO, 0.3f);
        FOTPlatform.addComposting((ItemLike)FOTItems.MANGO_PIT, 0.2f);
        FOTPlatform.addComposting((ItemLike)FOTItems.POMEGRANATE, 0.2f);
        FOTPlatform.addComposting((ItemLike)FOTItems.POMEGRANATE_SEEDS, 0.1f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.PINK_PLUMERIA, 0.6f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.LIGHT_BLUE_PLUMERIA, 0.6f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.WHITE_PLUMERIA, 0.6f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.COCONUT_FRONDS, 0.8f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.BANANA_LEAVES, 0.8f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.BANANA_BLOSSOM, 0.3f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.BANANA_SHOOTS, 0.25f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.UNDERRIPE_BANANA_CLUSTER, 0.5f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.BARELY_RIPE_BANANA_CLUSTER, 0.85f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.RIPE_BANANA_CLUSTER, 0.85f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.BANANA_STEM, 0.8f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK, 0.6f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.RIPE_PINEAPPLE_BLOCK, 0.75f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.CROWNLESS_RIPE_PINEAPPLE_BLOCK, 0.7f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.MANGO_LEAVES, 0.3f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.MANGO_SAPLING, 0.25f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.POMEGRANATE_PLANT, 0.25f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.TALL_POMEGRANATE_PLANT, 0.4f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.TROPICAL_RED_FERN, 0.4f);
        FOTPlatform.addComposting((ItemLike)FOTBlocks.TROPICAL_MONSTERA, 0.3f);
        FOTPlatform.addComposting((ItemLike)FOTItems.GUARDIAN_FRUIT, 0.3f);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRONDS, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.VERTICAL_COCONUT_FRONDS, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.VERTICAL_BANANA_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.PINK_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.LIGHT_BLUE_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.WHITE_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_PLANKS, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FENCE, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FENCE_GATE, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_SLAB, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_STAIRS, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRUIT, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRUIT_GROWABLE_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_TOP_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MEDIUM_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MEDIUM_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_MEDIUM_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_MEDIUM_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_SMALL_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_SMALL_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_STEM, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_CLUSTER_GROWABLE_STEM, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.PRISMARIZED_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BUDDING_PRISMARIZED_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_SHOOTS_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_SHOOTS, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_PIT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_FRUIT, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.POMEGRANATE_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TALL_POMEGRANATE_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_BLOSSOM, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_BLOSSOM_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.POMEGRANATE_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TROPICAL_RED_FERN, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TROPICAL_MONSTERA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.CROWNLESS_RIPE_PINEAPPLE_BLOCK, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_PINEAPPLE_BLOCK, 30, 20);
    }

    private static List<VillagerTrades.ItemListing> getFishermanTradesByLevel(int level, List<VillagerTrades.ItemListing> list) {
        switch (level) {
            case 1: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.SPLASHTAIL, 6, 1, FOTItems.COOKED_SPLASHTAIL, 6, 8, 1, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.PONDIE, 6, 1, FOTItems.COOKED_PONDIE, 6, 8, 1, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.ISLEHOPPER, 2, 2, FOTItems.COOKED_ISLEHOPPER, 2, 8, 2, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.ANCIENTSCALE, 3, 1, FOTItems.COOKED_ANCIENTSCALE, 3, 5, 3, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.EARTHWORMS, 48, 8, 10));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.GRUBS, 32, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.LEECHES, 24, 8, 14));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.SPLASHTAIL_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.PONDIE_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.ISLEHOPPER_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.ANCIENTSCALE_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 2: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.SPLASHTAIL, 12, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.PONDIE, 12, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.ISLEHOPPER, 8, 8, 15));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.ANCIENTSCALE, 8, 9, 15));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.PLENTIFIN, 3, 2, FOTItems.COOKED_PLENTIFIN, 3, 5, 3, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.WILDSPLASH, 4, 2, FOTItems.COOKED_WILDSPLASH, 4, 6, 3, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.DEVILFISH, 4, 3, FOTItems.COOKED_DEVILFISH, 4, 6, 4, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.PLENTIFIN_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.WILDSPLASH_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.DEVILFISH_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 3: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.PLENTIFIN, 8, 9, 17));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.WILDSPLASH, 8, 9, 17));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.DEVILFISH, 6, 10, 20));
                break;
            }
            case 4: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.BATTLEGILL, 6, 10, 20));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.WRECKER, 5, 12, 25));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.STORMFISH, 5, 12, 25));
                break;
            }
            case 5: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.BATTLEGILL, 4, 3, FOTItems.COOKED_BATTLEGILL, 4, 6, 4, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.WRECKER, 5, 5, FOTItems.COOKED_WRECKER, 5, 8, 5, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.STORMFISH, 5, 5, FOTItems.COOKED_STORMFISH, 5, 8, 8, 0.05f));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.BATTLEGILL_BUCKET, 6, 1, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.WRECKER_BUCKET, 6, 1, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.STORMFISH_BUCKET, 6, 1, 8, 2));
            }
        }
        return list;
    }

    public static CreativeModeTab.Builder getFishCreativeTabBuilder(CreativeModeTab.Builder builder) {
        return builder.title((Component)Component.translatable((String)"itemGroup.fishofthieves.fish")).icon(() -> new ItemStack((ItemLike)FOTItems.SPLASHTAIL)).displayItems(FOTDisplayItems::displayFishItems);
    }

    public static CreativeModeTab.Builder getMainCreativeTabBuilder(CreativeModeTab.Builder builder) {
        return builder.title((Component)Component.translatable((String)"itemGroup.fishofthieves.main")).icon(() -> new ItemStack((ItemLike)FOTBlocks.COCONUT_LOG)).displayItems(FOTDisplayItems::displayMainItems);
    }

    public static Int2ObjectOpenHashMap<Function<List<VillagerTrades.ItemListing>, List<VillagerTrades.ItemListing>>> getFishermanTrades() {
        return (Int2ObjectOpenHashMap)Util.make((Object)new Int2ObjectOpenHashMap(), map -> IntStream.rangeClosed(1, 5).boxed().forEach(level -> map.put(level.intValue(), list -> FishOfThieves.getFishermanTradesByLevel(level, list))));
    }

    public static Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> getEntityAttributes() {
        return (Map)Util.make((Object)Maps.newHashMap(), map -> {
            map.put(FOTEntities.SPLASHTAIL, AbstractFish.createAttributes());
            map.put(FOTEntities.PONDIE, AbstractFish.createAttributes());
            map.put(FOTEntities.ISLEHOPPER, AbstractFish.createAttributes());
            map.put(FOTEntities.ANCIENTSCALE, AbstractFish.createAttributes());
            map.put(FOTEntities.PLENTIFIN, AbstractFish.createAttributes());
            map.put(FOTEntities.WILDSPLASH, AbstractFish.createAttributes());
            map.put(FOTEntities.DEVILFISH, Devilfish.createAttributes());
            map.put(FOTEntities.BATTLEGILL, Battlegill.createAttributes());
            map.put(FOTEntities.WRECKER, Wrecker.createAttributes());
            map.put(FOTEntities.STORMFISH, AbstractFish.createAttributes());
        });
    }

    public static List<SpawnPlacementEntry<Mob>> getSpawnPlacements() {
        return ((ArrayList)Util.make((Object)Lists.newArrayList(), list -> {
            list.add(new SpawnPlacementEntry<Splashtail>(FOTEntities.SPLASHTAIL, WaterAnimal::checkSurfaceWaterAnimalSpawnRules));
            list.add(new SpawnPlacementEntry<Pondie>(FOTEntities.PONDIE, WaterAnimal::checkSurfaceWaterAnimalSpawnRules));
            list.add(new SpawnPlacementEntry<Islehopper>(FOTEntities.ISLEHOPPER, Islehopper::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Ancientscale>(FOTEntities.ANCIENTSCALE, Ancientscale::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Plentifin>(FOTEntities.PLENTIFIN, Plentifin::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Wildsplash>(FOTEntities.WILDSPLASH, Wildsplash::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Devilfish>(FOTEntities.DEVILFISH, Devilfish::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Battlegill>(FOTEntities.BATTLEGILL, Battlegill::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Wrecker>(FOTEntities.WRECKER, Wrecker::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Stormfish>(FOTEntities.STORMFISH, Stormfish::checkSpawnRules));
        })).stream().map(entry -> entry).toList();
    }

    public record SpawnPlacementEntry<T extends Mob>(EntityType<T> type, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
    }
}

